define([], function() {

  'use strict';

  /**
   * Checks if `value` is suitable for use as unique object key.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
   */
  function isKeyable(value) {
    var type = typeof value;
    return type == 'number' || type == 'boolean' ||
      (type == 'string' && value != '__proto__') || value == null;
  }

  return isKeyable;
});
